class GenerateCta {
   constructor(selector) {
      this.el = document.querySelector(selector);
      this._options = {};
      this.isClick = false;
      this.firsClick;
   }

   handleEvent(event) {
      if (event.currentTarget.classList.contains("boxes__item")) {
         const boxes = this.el.querySelector(".boxes");
         const boxesItem = this.el.querySelectorAll(".boxes__item");
         const closeBox = event.currentTarget.querySelector(".boxes__item-img[data-type='close']");
         const openBox = event.currentTarget.querySelector(".boxes__item-img[data-type='open']");
         const indexBox = event.currentTarget.dataset.index;

         if (!this.isClick) {
            this.firsClick = indexBox;
            openBox.classList.remove("hidden");
            closeBox.classList.add("hidden");

            setTimeout(() => {
               this.#spin();
            }, 200);

            setTimeout(() => {
               this.isClick = true;
            }, 300);
         }

         if (this.isClick && indexBox !== this.firsClick) {
            boxesItem.forEach((boxesElement) => {
               boxesElement.removeEventListener("click", this);
            });

            openBox.classList.remove("hidden");
            closeBox.classList.add("hidden");
            this.#discount(event);

            setTimeout(() => {
               this.#spin(this._options.scroll.target, this._options.scroll.type);
            }, 1000);
            setTimeout(() => {
               boxes.classList.add("none");
            }, 1300);

            setTimeout(() => {
               this.#order();
            }, 1500);
         }
      }
   }

   boxes(options) {
      const orederImg = this.el.querySelector(".order__img");
      const productName = this.el.querySelectorAll(".cta__name-product");
      const boxesItem = this.el.querySelectorAll(".boxes__item");
      this._options = options;

      boxesItem.forEach((boxes) => {
         boxes.addEventListener("click", this);
      });

      orederImg.setAttribute("src", options.img);
      productName.forEach((element) => {
         element.innerText = options.product;
      });
   }

   #discount(event) {
      const index = event.currentTarget.dataset.index;
      const currentBox = this.el.querySelector(`.boxes__item[data-index="${index}"]`);
      const currentImg = currentBox.querySelector(`.boxes__item-img[data-type="open"]`);
      const discount = document.querySelector(".price_land_discount").textContent;
      const discountItem = this.el.querySelector(`.boxes__item-discount[data-discount="${index}"]`);

      discountItem.classList.add("active");
      currentImg.classList.add("opacity");
      discountItem.innerHTML = `${discount}%`;
   }

   #spin(selector, type) {
      const scroll = this.el.querySelector(`${selector}`);
      const spin = this.el.querySelector(".spin");
      const spinContent = spin.querySelectorAll(".spin__content");
      const btnClose = spin.querySelectorAll(".spin__btn");

      if (!this.isClick) {
         spin.classList.add("active");
         btnClose[0].addEventListener("click", () => {
            spin.classList.remove("active");
            spinContent[0].classList.add("hidden");
         });
      }

      if (this.isClick) {
         spin.classList.add("active");
         spinContent[1].classList.remove("hidden");
         btnClose[1].addEventListener("click", () => {
            spin.classList.remove("active");
            scroll.scrollIntoView({ block: `${type}`, behavior: "smooth" });
            this.#timer();
         });
      }
   }

   #order() {
      const order = this.el.querySelector(".order");
      const orderSelect = order.querySelector(".order__select");
      order.classList.add("active");
      orderSelect.addEventListener("click", (e) => {
         e.currentTarget.classList.toggle("active");
      });
   }

   #timer() {
      const minuteElement = this.el.querySelector("#orderMinute");
      const secondElement = this.el.querySelector("#orderSecond");
      let timer = 60 * (10 - 0.01);
      let minutes;
      let seconds;

      const id = setInterval(() => {
         minutes = parseInt(timer / 60, 10);
         seconds = parseInt(timer % 60, 10);

         minutes = minutes < 10 ? "0" + minutes : minutes;
         seconds = seconds < 10 ? "0" + seconds : seconds;

         minuteElement.innerHTML = minutes;
         secondElement.innerHTML = seconds;
         if (--timer < 0) {
            timer = 0;
            clearInterval(id);
         }
      }, 1000);
   }
}
